/* include file for tlc96116 LED device 
*
*	Author: Ray Kuschan	: initial	:Jul 12 2013
*
*	Crestron Electronics
*
*/

//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// The TI TLC59116 LED controller (which also handles additional kinds of
//  h/w devices) in a Crestron TSW-750 supports the definitions below.
//
//  Reference(s):
//  - Crestron drawing SE 07020, "ONYX-7: CPU BOARD", rev. A4,
//    sheets 4-IMX53_MISC and 9-AUDIO.
//  - Crestron drawing SE 07022, "LED BOARD: ONYX-7", rev. A, sheet 2-LEDS.
//  - Texas Instruments literature number SLDS157B
//    ("TLC59116", FEBRUARY 2008–REVISED JULY 2008).

//-   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -
// For signal "~LEDS_RST_3V3" from CPU to LED controller's "~RESET" pin.
//
//  - Such definitions are specific to the circuit-board design.
//
// Port and Pin definitions are same for TSW-750 (ONYX-7), TSW-550 and TSW-1050.

//#define LEDS_RST_3V3_GPIO_PORT  (DDK_GPIO_PORT2)
//#define LEDS_RST_3V3_GPIO_PIN   (7)

//-   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -
// LED controller register addresses.
//
//  - NOTE:  This device driver should only touch registers that affect the
//           keypad backlight LEDs.  Other drivers may touch other registers
//           of the same h/w component, such as for the keypad buttons.
//
//  - Such definitions are specific to the h/w component,
//    regardless of the circuit board(s) on which it might be installed.
//
//  - Naming convention for symbols is 'KBL_TLC_REG_short', where....
//    -- 'KBL' refers to this "Keypad BackLight" device driver.
//    -- 'TLC' refers to the h/w part name, "TLC59116".
//    -- 'REG' is an abbreviation of "register".
//    -- "short" indicates the short name of the register in the datasheet.
//
//  - Comments show "Short name | Read/Write mode | Long name".
//

#define LEDS_RST_3V3            (1*32 + 7)  	// GPIO_2_7

#define KBL_TLC_REG_MODE1   (0x00)  // MODE1   | R/W | Mode 1.
#define KBL_TLC_REG_MODE2   (0x01)  // MODE2   | R/W | Mode 2.
#define KBL_TLC_REG_PWM0    (0x02)  // PWM0    | R/W | Brightness control LED0.
#define KBL_TLC_REG_PWM1    (0x03)  // PWM1    | R/W | Brightness control LED1.
#define KBL_TLC_REG_PWM2    (0x04)  // PWM2    | R/W | Brightness control LED2.
#define KBL_TLC_REG_PWM3    (0x05)  // PWM3    | R/W | Brightness control LED3.
#define KBL_TLC_REG_PWM4    (0x06)  // PWM4    | R/W | Brightness control LED4.
#define KBL_TLC_REG_PWM5    (0x07)  // PWM5    | R/W | Brightness control LED5.
#define KBL_TLC_REG_PWM6    (0x08)  // PWM6    | R/W | Brightness control LED6.
#define KBL_TLC_REG_PWM7    (0x09)  // PWM7    | R/W | Brightness control LED7.
#define KBL_TLC_REG_PWM8    (0x0A)  // PWM8    | R/W | Brightness control LED8.
#define KBL_TLC_REG_PWM9    (0x0B)  // PWM9    | R/W | Brightness control LED9.
#define KBL_TLC_REG_PWM10   (0x0C)  // PWM10   | R/W | Brightness control LED10.
#define KBL_TLC_REG_PWM11   (0x0D)  // PWM11   | R/W | Brightness control LED11.
#define KBL_TLC_REG_PWM12   (0x0E)  // PWM12   | R/W | Brightness control LED12.
#define KBL_TLC_REG_PWM13   (0x0F)  // PWM13   | R/W | Brightness control LED13.
#define KBL_TLC_REG_PWM14   (0x10)  // PWM14   | R/W | Brightness control LED14.
#define KBL_TLC_REG_PWM15   (0x11)  // PWM15   | R/W | Brightness control LED15.
#define KBL_TLC_REG_GRPPWM  (0x12)  // GRPPWM  | R/W | Group duty cycle control.
#define KBL_TLC_REG_GRPFREQ (0x13)  // GRPFREQ | R/W | Group frequency.
#define KBL_TLC_REG_LEDOUT0 (0x14)  // LEDOUT0 | R/W | LED output state 0.
#define KBL_TLC_REG_LEDOUT1 (0x15)  // LEDOUT1 | R/W | LED output state 1.
#define KBL_TLC_REG_LEDOUT2 (0x16)  // LEDOUT2 | R/W | LED output state 2.
#define KBL_TLC_REG_LEDOUT3 (0x17)  // LEDOUT3 | R/W | LED output state 3.
#define KBL_TLC_REG_SUBADR1 (0x18)  // SUBADR1 | R/W | I2C bus subaddress 1.
#define KBL_TLC_REG_SUBADR2 (0x19)  // SUBADR2 | R/W | I2C bus subaddress 2.
#define KBL_TLC_REG_SUBADR3 (0x1A)  // SUBADR3 | R/W | I2C bus subaddress 3.
#define KBL_TLC_REG_ALLCALLADR (0x1B) // ALLCALLADR | R/W | LED All Call I2C bus address.
#define KBL_TLC_REG_IREF    (0x1C)  // IREF    | R/W | IREF configuration.
#define KBL_TLC_REG_EFLAG1  (0x1D)  // EFLAG1  |  R  | Error flags 1.
#define KBL_TLC_REG_EFLAG2  (0x1E)  // EFLAG2  |  R  | Error flags 2.
#define KBL_TLC_AUTO_INC	(0xA0)  // Auto increment brightness registers

//ledout register values
#define	KBL_LEDOUT_OFF			(0x00)
#define	KBL_LEDOUT_ON			(0x01)
#define	KBL_LEDOUT_INDIVIDUAL	(0x02)
#define	KBL_LEDOUT_GROUP		(0x03)

